IF EXISTS
(
    SELECT *
      FROM SYS.VIEWS
     WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_NFCE_NR_TENTACLE]')
)
    DROP VIEW [DBO].[V_EST_NFCE_NR_TENTACLE];
GO

CREATE VIEW [DBO].[V_EST_NFCE_NR_TENTACLE]
AS
	 SELECT
		  CX_SERIE.CD_CTR
		  , CX.CD_EMP
		  , CX_SERIE.CD_FILIAL
		  , CX.CD_CX
		  , SERIE.SERIE AS CD_NF_SERIE
		  , ISNULL(CX_SERIE.NR_ULT, CX_SERIE.NR_INI) AS CD_NF_INI
	 FROM
		 PDV_CX CX 
		 INNER JOIN PDV_CX_EST_NF_SERIE CX_SERIE ON CX.CD_CTR_SERIE = CX_SERIE.CD_CTR
		 INNER JOIN EST_NF_SERIE SERIE ON CX_SERIE.CD_EMP = SERIE.CD_EMP
										  AND CX_SERIE.CD_NF_SERIE = SERIE.CD_NF_SERIE
	 WHERE  CX.CD_EMP = 1
			AND (SERIE.TP_SR_NFE = 1)
			AND (SERIE.COD_MODELO = '65');
